// Incorporate background mortality
// stored results
//    - rmst at 3 years
//    - mean survival
//    - AIC/BIC
//    - convergence

clear

// change to relavent foler
cd "Z:\TSD Simulation\tsd_simulation\Analysis_of_simulations\Background_mortality"


// program to extract results from stpm2 models
capture program drop get_bground_results
program define get_bground_results
	syntax, df(string)
	capture drop s3* s80*
	capture drop S0*
	capture drop surv_b*
	// background rates
	include ../../Scenario_Parameters/background_mortality_rate_gompertz.do							
	
		// rmst3
	drop _t
	range _t 0 3 1000
	capture predict s3, survival timevar(_t)
	gen surv_background=.
	levelsof _t, local(tlevs)
	gen double S0 = exp(-`lambda_gomp'/`gamma_gomp' *(exp(`gamma_gomp'*(age)) - 1))
	
	local j=0
	foreach t of local tlevs {
		local j=`j'+1	
		capture drop surv_background_temp* S0_tvar
		gen double S0_tvar = exp(-`lambda_gomp'/`gamma_gomp' *(exp(`gamma_gomp'*(age+`t')) - 1))
		gen surv_background_temp=S0_tvar/S0 
		egen surv_background_temp2=mean(surv_background_temp)
		replace surv_background=surv_background_temp2 in `j'
	}
	
	capture drop surv_background_temp*
	capture replace s3=s3*surv_background
	capture integ s3 _t
	c_local rmst3_df`df'= cond("`r(integral)'"!="","`r(integral)'",".")
	
		
	// meansurv
	drop _t
	drop surv_background
	gen surv_background=.
	range _t 0 80 1000
	
	levelsof _t, local(tlevs)
	
	capture predict s80, survival timevar(_t)
	drop S0_tvar
	
	local j=0
	foreach t of local tlevs {
		local j=`j'+1
		capture drop surv_background_temp* S0_tvar
		gen double S0_tvar = exp(-`lambda_gomp'/`gamma_gomp' *(exp(`gamma_gomp'*(age+`t')) - 1))
		gen surv_background_temp=S0_tvar/S0 
		egen surv_background_temp2=mean(surv_background_temp)
		replace surv_background=surv_background_temp2 in `j'
	}
	
	capture drop surv_background_temp*
	capture replace s80=s80*surv_background
	capture integ s80 _t	
	c_local meansurv_df`df' = cond("`r(integral)'"!="","`r(integral)'",".")
	
	replace _t = old_t	
	
	// AIC and BIC
	 count if _d == 1
	capture	estat ic, n(`r(N)')
	if _rc==0 {
		c_local AIC_df`df' = cond(`e(converged)',el(r(S),1,5),.)
		c_local BIC_df`df' = cond(`e(converged)',el(r(S),1,6),.)
	
		// convergence
		c_local converged_df`df' `e(converged)'
	}
	else { // estimation did not work
		c_local AIC_df`df' = .
		c_local BIC_df`df' = .
	
		// convergence set to 0
		c_local converged_df`df' 0
	}
end



set trace off 
// simulation number
local j 1 
// Maximum number of degrees of freedom for fitting an stpm2 model. Code below loops over 1,2,3,...,df_max
local df_max 5

// Scenario
foreach scen in 1 2 3 4  { 
	// sample size 
	foreach ss in  100 500  {

		// Low and medium survival
		foreach S in  1 2 {

		// Different frailty effects
			foreach F in 1 2 {

				// only run if results dataset does not exist
				if(fileexists("Scenario`scen'_S`S'_SS`ss'_F`F'.dta")!=1){
					di _newline "Scenario`scen'_S`S'_SS`ss'_F`F'"
					  quietly {
						//postfile
						postutil clear
						local newvars
						foreach x in rmst3 meansurv AIC BIC converged {
							foreach df of numlist 1/`df_max' {
								local newvars `newvars' `x'_df`df'
							}
							local newvars `newvars' `x'_dflowestAIC
						}
						local newvars `newvars' df_dflowestAIC
						di "`newvars'"
						postfile stpm2simbg `newvars' using Scenario`scen'_S`S'_SS`ss'_F`F'.dta,replace
					
						// loop over datasets
						forvalues j = 1/1000 {
							// load and analyse
							use ../../Simulated_Data/Scenario`scen'_S`S'_SS`ss'_F`F'/sim`j', clear
							constraint drop _all
							// background rates
							include ../../Scenario_Parameters/background_mortality_rate_gompertz.do							
							stset t d
							clonevar old_t = _t	
						gen double rate = `lambda_gomp' *(exp(`gamma_gomp'*(age+t)))
						
						foreach df of numlist 1/`df_max' {
								// fit model and get results
								 capture stpm2 , df(`df') scale(hazard) bhaz(rate)
								if _rc==0 {
									get_bground_results, df(`df')
								}
								else {
									local rmst3_df`df'=.
									local meansurv_df`df'=.
									local converged_df`df'=0
									local AIC_df`df' = .
									local BIC_df`df' = .									
								}
							}
							

							// results for model with lowest AIC
							scalar minAIC = 9999999 // some large number
							foreach df of numlist 1/`df_max' {
								if `AIC_df`df'' < minAIC {
									scalar minAIC = `AIC_df`df''
									foreach x in rmst3 meansurv AIC BIC converged {
										local `x'_dflowestAIC = ``x'_df`df''
									}
									local df_dflowestAIC = `df'
								}
							}
				
							// post values
							local postvals
							foreach x in rmst3 meansurv AIC BIC converged {
								foreach df of numlist 1/`df_max' {
									local postvals `postvals' (``x'_df`df'')
								}
								local postvals `postvals' (``x'_dflowestAIC')
							}
							local postvals `postvals' (`df_dflowestAIC')
							di "`postvals'"
							post stpm2simbg `postvals'
							noisily di "." _continue
						}
						postclose stpm2simbg
					}
				}
			}
		}
	}
}


